#!/bin/sh

HTML_PAGE="../setup_about.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

NET_DEVICE="eth0"

NAME="`uname -n`"
VERSIONOS="`cat /etc/.version 2>/dev/null`"
VERBOOT="`cat /proc/cpuinfo | grep -a \"swString\" | sed s/'^.*: '//`"
VERSIONBOOT="${VERBOOT:0:1}.${VERBOOT:1:2}"
VERSIONHW="`/sbin/mbinfo 2>&1 | grep \"HWString\" | sed s/'^.* : '//`"
FINALNO="`/sbin/mbinfo 2>&1 | grep \"ModulNo\" | sed s/'^.*: '//`"
MODULNO="`cat /proc/cpuinfo | grep -a \"modulNo\" | sed s/'^.*: '//`"
MAC="`/sbin/ifconfig $NET_DEVICE | grep 'HWaddr' | sed s/'^.*HWaddr '//`"
OS="`uname -o | sed s/'\/'/'%%'/`"
CPU="`cat /proc/cpuinfo | grep -a \"Processor\" | sed s/'^.*: '//`"
MEM="`cat /proc/meminfo | grep -a \"MemTotal\" | sed s/'^.*  '//` \/ `cat /proc/meminfo | grep -a \"MemFree\" | sed s/'^.*  '//`"
UPTIME="`uptime | sed s/'.*up '/''/ | sed s/',.*'/''/`"
BKLTIME="`/sbin/bklmon -i | grep 'Lifetime:' | awk '{print $2 " h " $4 " m"}'`"

if [ ! "$VERSIONOS" ]; then
    VERSIONOS="UNKNOWN"
fi

if [ ! "$VERBOOT" ]; then
    VERSIONBOOT="UNKNOWN"
fi

if [ ! "$VERSIONHW" ]; then
    VERSIONHW="UNKNOWN"
fi

if [ ! "$FINALNO" ]; then
    FINALNO="UNKNOWN"
fi

if [ ! "$MODULNO" ]; then
    MODULNO="UNKNOWN"
fi

if [ "$MINIBROWSER" ]; then
    echo "NAME=$NAME"
    echo "VERSIONOS=$VERSIONOS"
    echo "VERSIONBOOT=$VERSIONBOOT"
    echo "FINALNO=$FINALNO"
    echo "VERSIONHW=$VERSIONHW"
    echo "MODULNO=$MODULNO"
    echo "MAC=$MAC"
    echo "OS=`echo $OS | sed s/'%%'/'\/'/`"
    echo "CPU=$CPU"
    echo "MEM=`echo $MEM | sed s/'\\\'/''/`"
    echo "UPTIME=$UPTIME"
    echo "BKLTIME=$BKLTIME"
else
    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed s/'$NAME'/"$NAME"/g | sed s/'$VERSIONOS'/"$VERSIONOS"/g | sed s/'$VERSIONBOOT'/"$VERSIONBOOT"/g  \
        	   | sed s/'$FINALNO'/"$FINALNO"/g | sed s/'$VERSIONHW'/"$VERSIONHW"/g | sed s/'$MODULNO'/"$MODULNO"/g | sed s/'$MAC'/"$MAC"/g \
        	   | sed s/'$OS'/"$OS"/g | sed s/'$CPU'/"$CPU"/g | sed s/'$MEM'/"$MEM"/g | sed s/'$UPTIME'/"$UPTIME"/g | sed s/'$BKLTIME'/"$BKLTIME"/g \
        	   | sed s/'%%'/'\/'/g
fi
