#!/bin/sh

HTML_PAGE="/var/www/setup_display.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

if [ -r /etc/default/xserver ]; then
	. /etc/default/xserver
fi

SCRSAVER="`xset -display :0 q | grep timeout | sed s/'^.*t:  '/''/ | sed s/' .*'/''/`"
SCRSAVER="`expr $SCRSAVER \/ 60`"
BRIGHTNESS="`/sbin/setlcd -i | grep 'Brightness' | sed s/'^.*s: '/''/`"
CALIBRATE="no"

case "$SCRSAVER" in
    0)
	SCRSAVER_OPTION="<OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    5)
	SCRSAVER_OPTION="<OPTION>5min<\/OPTION><OPTION>off<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    15)
	SCRSAVER_OPTION="<OPTION>15min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    30)
	SCRSAVER_OPTION="<OPTION>30min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    60)
	SCRSAVER_OPTION="<OPTION>60min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION>"
	;;
    *)
	SCRSAVER_OPTION="<OPTION>$SCRSAVER\min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
esac

case "$BRIGHTNESS" in
    128)
	BRIGHTNESS="high"
	;;
    32)
	BRIGHTNESS="middle"
	;;
    18)
	BRIGHTNESS="low"
	;;
     8)
	BRIGHTNESS="low"
	;;
esac

case "$BRIGHTNESS" in
    high)
	BRIGHTNESS_OPTION="<OPTION>high<\/OPTION><OPTION>middle<\/OPTION><OPTION>low<\/OPTION>"
	;;
    middle)
	BRIGHTNESS_OPTION="<OPTION>middle<\/OPTION><OPTION>high<\/OPTION><OPTION>low<\/OPTION>"
	;;
    low)
	BRIGHTNESS_OPTION="<OPTION>low<\/OPTION><OPTION>high<\/OPTION><OPTION>middle<\/OPTION>"
	;;
esac

case "$XSERVER_CURSOR" in
    hand2)
	CURSOR="hand"
	;;
    shuttle)
	CURSOR="none"
	;;
    *)
	CURSOR="$XSERVER_CURSOR"
	;;
esac

case "$CURSOR" in
    X_cursor)
	CURSOR_OPTION="<OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>target<\/OPTION><OPTION>arrow<\/OPTION><OPTION>hand<\/OPTION><OPTION>spider<\/OPTION><OPTION>star<\/OPTION><OPTION>dot<\/OPTION><OPTION>none<\/OPTION>"
	;;
    crosshair)
	CURSOR_OPTION="<OPTION>crosshair<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>target<\/OPTION><OPTION>arrow<\/OPTION><OPTION>hand<\/OPTION><OPTION>spider<\/OPTION><OPTION>star<\/OPTION><OPTION>dot<\/OPTION><OPTION>none<\/OPTION>"
	;;
    target)
	CURSOR_OPTION="<OPTION>target<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>arrow<\/OPTION><OPTION>hand<\/OPTION><OPTION>spider<\/OPTION><OPTION>star<\/OPTION><OPTION>dot<\/OPTION><OPTION>none<\/OPTION>"
	;;
    arrow)
	CURSOR_OPTION="<OPTION>arrow<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>target<\/OPTION><OPTION>hand<\/OPTION><OPTION>spider<\/OPTION><OPTION>star<\/OPTION><OPTION>dot<\/OPTION><OPTION>none<\/OPTION>"
	;;
    hand)
	CURSOR_OPTION="<OPTION>hand<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>target<\/OPTION><OPTION>arrow<\/OPTION><OPTION>spider<\/OPTION><OPTION>star<\/OPTION><OPTION>dot<\/OPTION><OPTION>none<\/OPTION>"
	;;
    spider)
	CURSOR_OPTION="<OPTION>spider<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>target<\/OPTION><OPTION>arrow<\/OPTION><OPTION>hand<\/OPTION><OPTION>star<\/OPTION><OPTION>dot<\/OPTION><OPTION>none<\/OPTION>"
	;;
    star)
	CURSOR_OPTION="<OPTION>star<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>target<\/OPTION><OPTION>arrow<\/OPTION><OPTION>hand<\/OPTION><OPTION>spider<\/OPTION><OPTION>dot<\/OPTION><OPTION>none<\/OPTION>"
	;;
    dot)
	CURSOR_OPTION="<OPTION>dot<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>target<\/OPTION><OPTION>arrow<\/OPTION><OPTION>hand<\/OPTION><OPTION>spider<\/OPTION><OPTION>star<\/OPTION><OPTION>none<\/OPTION>"
	;;
    none)
	CURSOR_OPTION="<OPTION>none<\/OPTION><OPTION>X_cursor<\/OPTION><OPTION>crosshair<\/OPTION><OPTION>target<\/OPTION><OPTION>arrow<\/OPTION><OPTION>hand<\/OPTION><OPTION>spider<\/OPTION><OPTION>star<\/OPTION><OPTION>dot<\/OPTION>"
	;;
esac

SCRSAVER="$SCRSAVER`echo min`"

if [ "$MINIBROWSER" ]; then
    echo "CALIBRATE=$CALIBRATE"
    echo "SCRSAVER=$SCRSAVER"
    echo "BRIGHTNESS=$BRIGHTNESS"
    echo "CURSOR=$CURSOR"
else
    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed s/'$SCRSAVER_OPTION'/"$SCRSAVER_OPTION"/g \
		   | sed s/'$BRIGHTNESS_OPTION'/"$BRIGHTNESS_OPTION"/g | sed s/'$CURSOR_OPTION'/"$CURSOR_OPTION"/g
fi
