#!/bin/sh

HTML_PAGE="/var/www/setup_display.html"

#echo "Content-type: text/html"
#echo

XSERVER_CONFIG="/etc/default/xserver"
DISPLAY_CONFIG="/etc/default/display"

#echo "`env`"

DATA="`cat | sed s/'\&'/' '/g`"

#echo $DATA

CALIBRATE="`echo $DATA | sed s/' '/'\n'/g | grep CALIBRATE | sed s/'^.*='/''/`"
SCRSAVER="`echo $DATA | sed s/' '/'\n'/g | grep SCRSAVER | sed s/'^.*='/''/ | sed s/'min'/''/`"
BRIGHTNESS="`echo $DATA | sed s/' '/'\n'/g | grep BRIGHTNESS | sed s/'^.*='/''/`"

if [ "$CALIBRATE" = "yes" ]; then
    xtscal.sh >/dev/null 2>&1 &
fi

if [ "$SCRSAVER" = "off" ]; then
    TIMEOUT_MIN="0"
    TIMEOUT="0"
else
    TIMEOUT_MIN="`echo $SCRSAVER | sed s/'min'/''/`"
    TIMEOUT="`expr $TIMEOUT_MIN \* 60`"
fi

#echo "CALIBRATE  = $CALIBRATE"
#echo "SCRSAVER   = $SCRSAVER"
#echo "BRIGHTNESS = $BRIGHTNESS"
#echo "TIMEOUT    = $TIMEOUT"

#echo "xset -s $TIMEOUT"

xset -display :0 s $TIMEOUT

TMP_CONFIG=`cat $XSERVER_CONFIG`
TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^XSERVER_TIMEOUT=.*'/"XSERVER_TIMEOUT=$TIMEOUT_MIN"/`

echo "$TMP_CONFIG" > $XSERVER_CONFIG

case "$BRIGHTNESS" in
    high)
	BRIGHTNESS_NUM="128"
	;;
    middle)
	BRIGHTNESS_NUM="32"
	;;
    low)
	BRIGHTNESS_NUM="8"
	;;
esac

#echo /sbin/setlcd -s $BRIGHTNESS 256

/sbin/setlcd -s $BRIGHTNESS_NUM 256

TMP_CONFIG=`cat $DISPLAY_CONFIG`
TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DISPLAY_BRIGHTNESS=.*'/"DISPLAY_BRIGHTNESS=$BRIGHTNESS"/`

echo "$TMP_CONFIG" > $DISPLAY_CONFIG

sleep 2

sh setup_display.cgi
