#!/bin/sh

#echo "Content-type: text/html"
#echo

NET_DEVICE="eth0"

MIB_CONFIG="/opt/MiniBrowser/MiniBrowser.ini"

DATA="`cat | sed s/'\&'/' '/g`"

#echo $DATA

CONNECTION_TYPE="`echo $DATA | sed s/' '/'\n'/g | grep CONNECTION_TYPE | sed s/'^.*='/''/`"

PLC_IP_1="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_1 | sed s/'^.*='/''/`"
PLC_IP_2="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_2 | sed s/'^.*='/''/`"
PLC_IP_3="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_3 | sed s/'^.*='/''/`"
PLC_IP_4="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_4 | sed s/'^.*='/''/`"

PLC_SERIAL_SPEED="`echo $DATA | sed s/' '/'\n'/g | grep PLC_SERIAL_SPEED | sed s/'^.*='/''/`"
TCL2_ADDRESS="`echo $DATA | sed s/' '/'\n'/g | grep TCL2_ADDRESS | sed s/'^.*='/''/ | sed s/'+'/' '/g | sed s/'%2C'/','/g`"
PANEL_INDEX="`echo $DATA | sed s/' '/'\n'/g | grep PANEL_INDEX | sed s/'^.*='/''/`"

TMP_CONFIG=`cat $MIB_CONFIG | sed '/^\[plc\]/,/^$/d'`

if [ "$CONNECTION_TYPE" -a "$PLC_IP_1" -a "$PLC_IP_2" -a "$PLC_IP_3" -a "$PLC_IP_4" -a "$PLC_SERIAL_SPEED" -a "$TCL2_ADDRESS" ]; then
    CNT_CONFIG=`echo -n "\[plc\]\n"; \
		echo -n "ip                             = $PLC_IP_1.$PLC_IP_2.$PLC_IP_3.$PLC_IP_4\n"; \
		echo -n "connection_type                = $CONNECTION_TYPE\n"; \
		echo -n "serial_speed                   = $PLC_SERIAL_SPEED\n"; \
		echo -n "tcl2_address                   = $TCL2_ADDRESS\n"; \
		echo -n "\n"; \
		echo -n "\[server\]"`

    TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^\[server\]"/"$CNT_CONFIG"/`

    echo "$TMP_CONFIG" > $MIB_CONFIG
fi

if [ "$PANEL_INDEX" ]; then
    sed -i /'^panel_address'/s/'=.*'/"= $PANEL_INDEX"/ $MIB_CONFIG
fi

if [ "$CONNECTION_TYPE" = "TCL2" ]; then
    cd /opt/stm32
    ./create_id >/dev/null 2>&1
    cd -
fi

if [ ! "$MINIBROWSER" ]; then
    killall MiniBrowser >/dev/null 2>&1
fi

sleep 1

sh setup_connection.cgi
