#!/bin/sh

if [ ! "$MINIBROWSER" ]; then
. auth.cgi
. update.cgi
fi

HTML_PAGE="../setup_connection.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

MIB_CONFIG="/opt/MiniBrowser/MiniBrowser.ini"

CONNECTION_TYPE="$(sed '/\[plc\]/,/^$/!d/^connection_type/!ds/^.*= //g' "$MIB_CONFIG")"
CONNECTION_LIST="$(sed '/\[connectivity\]/,/^$/!d/^connection_list/!ds/^.*= //g' "$MIB_CONFIG")"

CONNECTION_TYPE_OPTION="<OPTION>${CONNECTION_TYPE}<\/OPTION>"

IFS="|"
for i in ${CONNECTION_LIST}; do
    if [ "$i" != "$CONNECTION_TYPE" ]; then
	CONNECTION_TYPE_OPTION="${CONNECTION_TYPE_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

PLC_ADDR="$(sed '/\[plc\]/,/^$/!d/^ip/!ds/^.*= //g' "$MIB_CONFIG")"

if [ ! "$PLC_ADDR" ]; then
    PLC_ADDR="0.0.0.0"
fi

PLC_IP_1="$(echo "$PLC_ADDR" | awk -F "." '{print $1}')"
PLC_IP_2="$(echo "$PLC_ADDR" | awk -F "." '{print $2}')"
PLC_IP_3="$(echo "$PLC_ADDR" | awk -F "." '{print $3}')"
PLC_IP_4="$(echo "$PLC_ADDR" | awk -F "." '{print $4}')"

PLC_SERIAL_SPEED="$(sed '/\[plc\]/,/^$/!d/^serial_speed/!ds/^.*= //g' "$MIB_CONFIG")"
PLC_SERIAL_SPEED_LIST="$(sed '/\[connectivity\]/,/^$/!d/^serial_speed_list/!ds/^.*= //g' "$MIB_CONFIG")"

PLC_SERIAL_SPEED_OPTION="<OPTION>${PLC_SERIAL_SPEED}<\/OPTION>"

IFS="|"
for i in ${PLC_SERIAL_SPEED_LIST}; do
    if [ "$i" != "$PLC_SERIAL_SPEED" ]; then
	PLC_SERIAL_SPEED_OPTION="${PLC_SERIAL_SPEED_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

TCL2_ADDRESS="$(sed '/\[plc\]/,/^$/!d/^tcl2_address/!ds/^.*= //g' "$MIB_CONFIG")"
TCL2_ADDRESS_LIST="$(sed '/\[connectivity\]/,/^$/!d/^tcl2_address_list/!ds/^.*= //g' "$MIB_CONFIG")"

TCL2_ADDRESS_OPTION="${TCL2_ADDRESS_OPTION}<OPTION>${TCL2_ADDRESS}<\/OPTION>"

IFS="|"
for i in ${TCL2_ADDRESS_LIST}; do
    if [ "$i" != "$TCL2_ADDRESS" ]; then
	TCL2_ADDRESS_OPTION="${TCL2_ADDRESS_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

PANEL_INDEX="$(sed '/\[browser\]/,/^$/!d/^panel_address/!ds/^.*= //g' "$MIB_CONFIG")"

if [ "$MINIBROWSER" ]; then
    echo "CONNECTION_TYPE=$CONNECTION_TYPE"
    echo "CONNECTION_LIST=$CONNECTION_LIST"
    echo "PLC_IP_1=$PLC_IP_1"
    echo "PLC_IP_2=$PLC_IP_2"
    echo "PLC_IP_3=$PLC_IP_3"
    echo "PLC_IP_4=$PLC_IP_4"
    echo "PLC_SERIAL_SPEED=$PLC_SERIAL_SPEED"
    echo "PLC_SERIAL_SPEED_LIST=$PLC_SERIAL_SPEED_LIST"
    echo "TCL2_ADDRESS=$TCL2_ADDRESS"
    echo "TCL2_ADDRESS_LIST=$TCL2_ADDRESS_LIST"
    echo "PANEL_INDEX=$PANEL_INDEX"
else
    LOGOUT_REF=""

    if [ "$PASSWORD_MB" ]; then
	LOGOUT_REF="                        \<A href=\"setup_logout.cgi\" title=\"Logout\"\>Logout\<\/A\>"
    fi

    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed /"setup_logout.cgi"/s/"^.*$"/"$LOGOUT_REF"/ | sed s/'$CONNECTION_TYPE_OPTION'/"$CONNECTION_TYPE_OPTION"/g \
    		   | sed s/'$PLC_IP_1'/"$PLC_IP_1"/g | sed s/'$PLC_IP_2'/"$PLC_IP_2"/g | sed s/'$PLC_IP_3'/"$PLC_IP_3"/g | sed s/'$PLC_IP_4'/"$PLC_IP_4"/g \
    		   | sed s/'$PLC_SERIAL_SPEED_OPTION'/"$PLC_SERIAL_SPEED_OPTION"/g | sed s/'$TCL2_ADDRESS_OPTION'/"$TCL2_ADDRESS_OPTION"/g \
    		   | sed s/'$PANEL_INDEX'/"$PANEL_INDEX"/g
fi
