#!/bin/sh

if [ ! "$MINIBROWSER" ]; then
. auth.cgi
fi

HTML_PAGE="../setup_debug.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

if [ -r /etc/default/plcsync ]; then
	. /etc/default/plcsync
fi

if [ "$DEBUG" = yes ]; then
    PLCSYNCLOG_OPTION="checked"
fi

if [ -r /etc/default/plccoms ]; then
	. /etc/default/plccoms
fi

if [ "$DEBUG" = yes ]; then
    PLCCOMSLOG_OPTION="checked"
fi

if [ -r /etc/default/minibrowser ]; then
	. /etc/default/minibrowser
fi

if [ "$DEBUG" = yes ]; then
    MBROWSERLOG_OPTION="checked"
fi

CACHEINFO="`du -h $CACHE_DIR/ | awk '{print $1}'`"

if [ "$CACHEINFO" = "0" ]; then
    CACHEINFO="0K"
fi

CACHEINFO="$CACHEINFO`echo -n 'B'`"

if [ "$MINIBROWSER" ]; then
    echo "PLCSYNCLOG_OPTION=$PLCSYNCLOG_OPTION"
    echo "PLCCOMSLOG_OPTION=$PLCCOMSLOG_OPTION"
    echo "MBROWSERLOG_OPTION=$MBROWSERLOG_OPTION"
else
    LOGOUT_REF=""

    if [ "$PASSWORD_MB" ]; then
	LOGOUT_REF="                        \<A href=\"setup_logout.cgi\" title=\"Logout\"\>Logout\<\/A\>"
    fi

    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed /"setup_logout.cgi"/s/"^.*$"/"$LOGOUT_REF"/ | sed s/'$PLCSYNCLOG_OPTION'/"$PLCSYNCLOG_OPTION"/g \
        	   | sed s/'$PLCCOMSLOG_OPTION'/"$PLCCOMSLOG_OPTION"/g | sed s/'$MBROWSERLOG_OPTION'/"$MBROWSERLOG_OPTION"/g \
        	   | sed s/'$CACHEINFO'/"$CACHEINFO"/g
fi
