#!/bin/sh

#echo "Content-type: text/html"
#echo

if [ -r /etc/default/xserver ]; then
	. /etc/default/xserver
fi

if [ "$XSERVER_ROTATION" = "" ]; then
    XSERVER_ROTATION="0"
fi

W="240"
H="136"
WF=`fbset | grep "geometry" | awk {'print $2'}`
HF=`fbset | grep "geometry" | awk {'print $3'}`

WIDTH="$W"
HEIGHT="$H"
WIDTH_FULL="$WF"
HEIGHT_FULL="$HF"

case "$XSERVER_ROTATION" in
    0)
	WIDTH="$W"
	HEIGHT="$H"
	WIDTH_FULL="$WF"
	HEIGHT_FULL="$HF"
	;;
    90)
	WIDTH="$H"
	HEIGHT="$W"
	WIDTH_FULL="$HF"
	HEIGHT_FULL="$WF"
	;;
    180)
	WIDTH="$W"
	HEIGHT="$H"
	WIDTH_FULL="$WF"
	HEIGHT_FULL="$HF"
	;;
    270)
	WIDTH="$H"
	HEIGHT="$W"
	WIDTH_FULL="$HF"
	HEIGHT_FULL="$WF"
	;;
esac

TMP_DIR="/tmp"
LOGO_DIR="/tmp"
TECO_LOGO_DIR="/etc/logo"

COLOR="#000000"

CONTENT_ID=`echo $CONTENT_TYPE | sed s/'^.*boundary=-*'//`

OUT=`/sbin/cgidump -i $CONTENT_ID -s $CONTENT_LENGTH -d $TMP_DIR` #> $TMP_DIR/cgidump.log 2>&1`

STATUS="$?"

FILE_NAME=`echo "$OUT" | grep "Dumping file:" | sed 's/^Dumping file: //'`
DELETE=`echo "$OUT" | grep "Dumping variable: DELETE" | sed 's/^Dumping variable: DELETE=//'`

if [ "$STATUS" != "0" ]; then
    COLOR="#FF0000"
    MESSAGE="Upload error!"
else
    if [ "$FILE_NAME" != "" ]; then
	IMGCONV_ERR1=`imgconv -x "$WIDTH_FULL" -y "$HEIGHT_FULL" -i "$TMP_DIR/$FILE_NAME" -o "$LOGO_DIR/.logo_new.bmp" 2>&1`

	ERR="$?"

	if [ "$ERR" == "0" ]; then
	    mv "$LOGO_DIR/.logo_new.bmp" "$LOGO_DIR/.logo.bmp"
	fi

	STATUS="$(($STATUS + $ERR))"

	IMGCONV_ERR2=`imgconv -x "$WIDTH" -y "$HEIGHT" -i "$TMP_DIR/$FILE_NAME" -o "$LOGO_DIR/.logo_thumb_new.bmp" 2>&1`

	ERR="$?"

	if [ "$ERR" == "0" ]; then
	    mv "$LOGO_DIR/.logo_thumb_new.bmp" "$LOGO_DIR/.logo_thumb.bmp"
	fi

	STATUS="$(($STATUS + $ERR))"

	rm -f $TMP_DIR/$FILE_NAME
    fi

    if [ "$DELETE" != "" ]; then
	rm -f "$LOGO_DIR/.logo.bmp"
	rm -f "$LOGO_DIR/.logo_thumb.bmp"
	cp -Lp "$TECO_LOGO_DIR/logo_teco_$XSERVER_ROTATION.bmp" "$LOGO_DIR/.logo.bmp"
	cp -Lp "$TECO_LOGO_DIR/logo_teco_thumb_$XSERVER_ROTATION.bmp" "$LOGO_DIR/.logo_thumb.bmp"
    fi

    if [ -f "$LOGO_DIR/.logo.bmp" ]; then
	flash_eraseall /dev/mtd7 >/dev/null 2>&1
	nandwrite -p /dev/mtd7 "$LOGO_DIR/.logo.bmp" >/dev/null 2>&1
    fi

    if [ "$STATUS" != "0" ]; then
	COLOR="#FF0000"
	MESSAGE="<P>ERROR: Wrong image format.<\P>"
    else
	if [ "$FILE_NAME" != "" ]; then
	    MESSAGE="Upload was successful."
	fi
	if [ "$DELETE" != "" ]; then
	    MESSAGE="Logo was deleted successfully."
	fi
    fi
fi

export MESSAGE="$MESSAGE"
export COLOR="$COLOR"

sh setup_logo.cgi
