#!/bin/sh

#echo "Content-type: text/html"
#echo

MIB_CONFIG="/opt/MiniBrowser/MiniBrowser.ini"

if [ -r /etc/default/webserver ]; then
	. /etc/default/webserver
fi

if [ ! -f "$AUTH_DB_FILE" ]; then
    touch "$AUTH_DB_FILE"
fi

PASSWORD_MB=`cat "$MIB_CONFIG" | grep -i "setup_password" | sed s/"^.*=[ |\t]*"/""/`
PASSWORD_DB=`head -n 1 "$AUTH_DB_FILE"`

if [ "$PASSWORD_MB" ]; then
    if [ "$PASSWORD_DB" != "$PASSWORD_MB" ]; then
	./setup_login.cgi
	exit 0
    fi


    REMOTE_ADDR_DB=`cat $AUTH_DB_FILE | grep "$REMOTE_ADDR" | awk '{print $1}'`
    TIME_MARK_DB=`cat $AUTH_DB_FILE | grep "$REMOTE_ADDR" | awk '{print $2}'`

    if [ ! "$TIME_MARK_DB" ];then
	TIME_MARK_DB="0"
    fi

    TIME_MARK=`date +%s`
    TIME_MARK_DIFF="$(($TIME_MARK-$TIME_MARK_DB))"

    if [ "$(($TIME_MARK_DIFF<0))" = "1" ]; then
	TIME_MARK_DIFF="$AUTH_TIMEOUT"
    fi

#echo "<P>REMOTE_ADDR_DB: $REMOTE_ADDR_DB</P>"
#echo "<P>TIME_MARK_DB: $TIME_MARK_DB</P>"
#echo "<P>TIME_MARK: $TIME_MARK</P>"
#echo "<P>TIME_MARK_DIFF: $TIME_MARK_DIFF</P>"

    if [ ! "$REMOTE_ADDR_DB" -o "$(($TIME_MARK_DIFF<$AUTH_TIMEOUT))" = "0" ]; then
	./setup_login.cgi
	exit 0
    fi

    AUTH_DB=`cat $AUTH_DB_FILE`
    AUTH_DB=`echo "$AUTH_DB" | sed /"$REMOTE_ADDR"/s/"^.*$"/"$REMOTE_ADDR $TIME_MARK"/`

    echo "$AUTH_DB" > $AUTH_DB_FILE
else
    rm -f "$AUTH_DB_FILE"
fi
