#!/bin/sh

if [ ! "$MINIBROWSER" ]; then
. auth.cgi
fi

HTML_PAGE="../setup_logo.html"

echo "Content-type: text/html"
echo

if [ -r /etc/default/xserver ]; then
	. /etc/default/xserver
fi

if [ "$XSERVER_ROTATION" = "" ]; then
    XSERVER_ROTATION="0"
fi

RNDNUM=`hexdump -C -n 8 /dev/urandom | sed s/' '/''/g | sed s/'|.*$'/''/ | head -n 1`

W="240"
H="136"
WF=`fbset | grep "geometry" | awk {'print $2'}`
HF=`fbset | grep "geometry" | awk {'print $3'}`

WIDTH="$W"
HEIGHT="$H"
WIDTH_FULL="$WF"
HEIGHT_FULL="$HF"

case "$XSERVER_ROTATION" in
    0)
	WIDTH="$W"
	HEIGHT="$H"
	WIDTH_FULL="$WF"
	HEIGHT_FULL="$HF"
	;;
    90)
	WIDTH="$H"
	HEIGHT="$W"
	WIDTH_FULL="$HF"
	HEIGHT_FULL="$WF"
	;;
    180)
	WIDTH="$W"
	HEIGHT="$H"
	WIDTH_FULL="$WF"
	HEIGHT_FULL="$HF"
	;;
    270)
	WIDTH="$H"
	HEIGHT="$W"
	WIDTH_FULL="$HF"
	HEIGHT_FULL="$WF"
	;;
esac

LOGO_DIR="/tmp"
LOGO_NAME=".logo.bmp"

if [ ! -f "$LOGO_DIR/.logo_thumb.bmp" ]; then
    imgconv -x "$WIDTH" -y "$HEIGHT" -i "$LOGO_DIR/$LOGO_NAME" -o "$LOGO_DIR/.logo_thumb.bmp" >/dev/null 2>&1
fi

LOGOUT_REF=""

if [ "$PASSWORD_MB" ]; then
    LOGOUT_REF="                        \<A href=\"setup_logout.cgi\" title=\"Logout\"\>Logout\<\/A\>"
fi

cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g |  sed /"setup_logout.cgi"/s/"^.*$"/"$LOGOUT_REF"/ | sed s/'$WIDTH_FULL'/"$WIDTH_FULL"/g | sed s/'$HEIGHT_FULL'/"$HEIGHT_FULL"/g \
	       | sed s/'$WIDTH'/"$WIDTH"/g | sed s/'$HEIGHT'/"$HEIGHT"/g \
	       | sed s/'$RNDNUM'/"$RNDNUM"/g | sed s/'$MESSAGE'/"$MESSAGE"/g | sed s/'$COLOR'/"$COLOR"/g
